<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />
<xsl:template match="/">
<html>
  <head>
    <title></title>
    <style>
        /*** BASIC ELEMENTS ***/
    body {
        background: #fff;
        font: normal 11px Arial, Helvetica, sans-serif;
        color: #000;
        margin: 0px;
    }

    h1 {
      font-weight: bold;
      font-size: 26px;
      text-transform: uppercase;
      color: #333;
    }

    h2 {
      font-weight: bold;
      font-size: 20px;
      text-transform: uppercase;
      color: #333;
    }

    h3 {
      font-weight: bold;
      font-size: 16px;
      color: #333;
    }

    table {
      border-collapse: collapse;
      margin: 0px 10px 20px 10px;
      border: 1px solid #000;
      width: 700px;
      background: #fff;
      font-size: 11px;
     }

    caption {
      caption-side: top;
      margin-bottom: 0px;
      margin-left: 9px;
      margin-right: 10px;
      padding: 5px;
      text-transform: uppercase;
    }

    td {
      border: 1px dotted #666;
      padding: 5px;
    }

    th {
      text-align: left;
      padding: 5px;
      border-right: 1px dotted #666;
    }

    /*** CUSTOM ELEMENTS ***/
    .shaded {
      background: #dcdcdc;
    }

    #contractor_tbl {
        float: left;
        margin-right: 20px;
        border: 1px solid #600;
      width: 290px;
      background: #f0f8ff;
    }

    #contractor_tbl th {
        text-align: right;
      border: none;
      width: 65px;
    }

    #contractor_tbl td {
      padding: 5px;
      border: none;
    }

    #job_tbl {
        border: 1px solid #600;
        padding: 10px;
      width: 290px;
      background: #f0f8ff;
    }

    #job_tbl th {
        text-align: right;
      border: none;
      width: 65px;
    }

    #job_tbl td {
      padding: 5px;
      border: none;
    }

    .cleardiv {
        clear: both;
    }

    .detail_grp {
        border: 1px dashed #666;
      background: #f0f8ff;
      padding: 10px;
      margin: 10px;
      width: 650px;
    }

    .test_sum {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 650px;
    }

    .test_sum th {
      background: #703000;
      color: #fff;
      padding: 5px;
    }

    .test_sum td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
      font-weight: bold;
    }

    .test_sum caption {
      text-align: left;
      background: #a05040;
      font-weight: bold;
      color: #000000;
    }

    .wiremap_test {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 620px;
    }

    .wiremap_test th {
      background: #4040b0;
      color: #fff;
      padding: 5px;
    }

    .wiremap_test td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
    }

    .wiremap_test caption {
      text-align: left;
      background: #6060ff;
      font-weight: bold;
      color: #000000;
    }

    .link_test {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 620px;
    }

    .link_test th {
      background: #40b040;
      color: #fff;
      padding: 5px;
    }

    .link_test td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
    }

    .link_test caption {
      text-align: left;
      background: #60ff60;
      font-weight: bold;
      color: #000000;
    }

    .perf_test {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 620px;
    }

    .perf_test th {
      background: #dc143c;
      color: #fff;
      padding: 5px;
    }

    .perf_test td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
    }

    .perf_test caption {
      text-align: left;
      background: #ff6060;
      font-weight: bold;
      color: #000000;
    }

    .dhcp_test {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 620px;
    }

    .dhcp_test th {
      background: #d0d000;
      color: #fff;
      padding: 5px;
    }

    .dhcp_test td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
    }

    .dhcp_test caption {
      text-align: left;xml
      background: #f0f010;
      font-weight: bold;
      color: #000000;
    }

    .ping_test {
      border-top: 1px solid #000;
      border-right: 1px solid #000;
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      width: 620px;
    }

    .ping_test th {
      background: #c040c0;
      color: #fff;
      padding: 5px;
    }

    .ping_test td {
      border-top: 1px dotted #666;
      border-right: 1px dotted #666;
      border-bottom: 1px dotted #666;
      border-left: 1px dotted #666;
      padding: 5px;
    }

    .ping_test caption {
      text-align: left;
      background: #ff80ff;
      font-weight: bold;
      color: #000000;
    }

    .red {
        color: #900;
      text-transform: uppercase;
    }

    .green {
      color: #090;
      text-transform: uppercase;
    }
    </style>

    </head>
    <body>
    <h1>SignalTek Test Report</h1>
        <table id="contractor_tbl">
            <tbody>
                <tr>
                    <th>Contractor:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Company"/></td>
                </tr>
                <tr>
                    <th>Contact:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Name"/></td>
                </tr>
                <tr>
                    <th>Address:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Address1"/></td>
                </tr>
                <tr>
                    <th/>
                    <td><xsl:value-of select="Report/Header/Contractor/Address2"/></td>
                </tr>
                <tr>
                    <th/>
                    <td>
                        <xsl:value-of select="Report/Header/Contractor/City"/>,
                        <xsl:value-of select="Report/Header/Contractor/State"/>&#160;
                        <xsl:value-of select="Report/Header/Contractor/Zip"/>
                    </td>
                </tr>
                <tr>
                    <th>Country:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Country"/></td>
                </tr>
                <tr>
                    <th>Phone:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Phone1"/></td>
                </tr>
                <tr>
                    <th>Phone:</th>
                    <td><xsl:value-of select="Report/Header/Contractor/Phone2"/></td>
                </tr>
            </tbody>
        </table>
        <table id="job_tbl">
            <tbody>
            <tr>
                <th>Job:</th>
                <td><xsl:value-of select="/Report/Header/Job/Company"/></td>
            </tr>
            <tr>
                <th>Contact:</th>
                <td><xsl:value-of select="/Report/Header/Job/Name"/></td>
            </tr>
            <tr>
                <th>Address:</th>
                <td><xsl:value-of select="/Report/Header/Job/Address1"/></td>
            </tr>
            <tr>
                <th/>
                <td><xsl:value-of select="/Report/Header/Job/Address2"/></td>
            </tr>
            <tr>
                <th/>
                <td>
                    <xsl:value-of select="/Report/Header/Job/City"/>,
                    <xsl:value-of select="/Report/Header/Job/State"/>&#160;
                    <xsl:value-of select="/Report/Header/Job/Zip"/>
                </td>
            </tr>
            <tr>
                <th>Country:</th>
                <td><xsl:value-of select="/Report/Header/Job/Country"/></td>
            </tr>
            <tr>
                <th>Phone:</th>
                <td><xsl:value-of select="/Report/Header/Job/Phone1"/></td>
            </tr>
            <tr>
                <th>Phone:</th>
                <td><xsl:value-of select="/Report/Header/Job/Phone2"/></td>
            </tr>
        </tbody>
    </table>
    <div class="cleardiv"></div>
        <!-- <h2>Test Summary</h2> -->
        <table class="test_sum">
        <caption>Test Summary</caption>
                <tr>
                    <th>Cable ID</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Wiremap</th>
                    <th>Link</th>
                    <th>Cable</th>
                    <th>VoIP</th>
                    <th>Web</th>
                    <th>Video</th>
                    <th>DHCP</th>
                    <th>Ping</th>
                </tr>
                <xsl:for-each select="Report/Test/Cable">
                    <xsl:sort select="@ID" order="ascending" />
                    <tr>
                        <td><a href="#{@ID}"><xsl:value-of select="@ID"/></a></td>
                        <td><xsl:value-of select="@Date"/></td>
                        <td><xsl:value-of select="@Time"/></td>
                        <xsl:choose>
                            <xsl:when test='Wiremap/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="Wiremap/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="Wiremap/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='LinkEstablishment/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="LinkEstablishment/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="LinkEstablishment/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='CablePerformance/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="CablePerformance/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="CablePerformance/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='VoIPPerformance/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="VoIPPerformance/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="VoIPPerformance/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='WebPerformance/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="WebPerformance/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="WebPerformance/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='VideoPerformance/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="VideoPerformance/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="VideoPerformance/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='DHCP/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="DHCP/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="DHCP/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                        <xsl:choose>
                            <xsl:when test='Ping/@Result = "Fail"'>
                                <td class="red">
                                    <xsl:value-of select="Ping/@Result"/>
                                </td>
                            </xsl:when>
                            <xsl:otherwise>
                                <td class="green">
                                    <xsl:value-of select="Ping/@Result"/>
                                </td>
                            </xsl:otherwise>
                        </xsl:choose>
                    </tr>
                </xsl:for-each>
        </table>
    <h1>Test Details</h1>
    <xsl:for-each select="Report/Test/Cable">
    <xsl:sort select="@ID" order="ascending" />
        <a name="{@ID}" />
        <div class="detail_grp">
        <h3>
            Cable ID:&#160;<![CDATA[ ]]>
            <em><xsl:value-of select="@ID"/></em>&#160;&#160;
            Cable Type:&#160;<![CDATA[ ]]>
            <em><xsl:value-of select="@Type"/></em>
        </h3>
            <table class="wiremap_test">
                <caption>Wiremap Test</caption>
                <tbody>
                    <tr>
                        <th>Pair</th>
                        <th>Length</th>
                        <th>Skew</th>
                        <th>Status</th>
                        <th>Polarity</th>
                        <th>Crossed</th>
                    </tr>
                    <xsl:for-each select="Wiremap/Pair">
                        <tr>
                            <td><xsl:value-of select="@ID"/></td>
                            <td><xsl:value-of select="@length"/></td>
                            <td><xsl:value-of select="@skew"/></td>
                            <td><xsl:value-of select="@status"/></td>
                            <td><xsl:value-of select="@polarity"/></td>
                            <td><xsl:value-of select="@cross"/></td>
                        </tr>
                    </xsl:for-each>
                    <tr>
                    <th>NVP</th>
                    </tr>
                    <tr>
                      <td><xsl:value-of select="Wiremap/NVP"/></td>
                    </tr>
                    <tr>
                        <th>Shielded Cable</th>
                        <th>Result</th>
                        <th>Link Type</th>
                        <th>Link Rate</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="Wiremap/Shielded/@Cable"/></td>
                        <td><xsl:value-of select="Wiremap/Shielded/@Result"/></td>
                        <td><xsl:value-of select="Wiremap/Shielded/@LinkType"/></td>
                        <td><xsl:value-of select="Wiremap/Shielded/@Rate"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="link_test">
                <caption>Link Establishment Test</caption>
                <tbody>
                    <tr>
                        <th>Status</th>
                        <th>Rate</th>
                        <th>Duplex</th>
                        <th>MDI</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="LinkEstablishment/@Status"/></td>
                        <td><xsl:value-of select="LinkEstablishment/@Rate"/></td>
                        <td><xsl:value-of select="LinkEstablishment/@Duplex"/></td>
                        <td><xsl:value-of select="LinkEstablishment/@MDI"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="perf_test">
                <caption>Cable Performance Test</caption>
                <tbody>
                    <tr>
                        <th>Threshold</th>
                        <th>Duration</th>
                        <th>Transmit</th>
                        <th>Receive</th>
                        <th>Error</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="CablePerformance/@Threshold"/></td>
                        <td><xsl:value-of select="CablePerformance/@Duration"/></td>
                        <td><xsl:value-of select="CablePerformance/@Transmit"/></td>
                        <td><xsl:value-of select="CablePerformance/@Receive"/></td>
                        <td><xsl:value-of select="CablePerformance/@Error"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="perf_test">
                <caption>VoIP Performance Test</caption>
                <tbody>
                    <tr>
                        <th>Threshold</th>
                        <th>Duration</th>
                        <th>Transmit</th>
                        <th>Receive</th>
                        <th>Error</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="VoIPPerformance/@Threshold"/></td>
                        <td><xsl:value-of select="VoIPPerformance/@Duration"/></td>
                        <td><xsl:value-of select="VoIPPerformance/@Transmit"/></td>
                        <td><xsl:value-of select="VoIPPerformance/@Receive"/></td>
                        <td><xsl:value-of select="VoIPPerformance/@Error"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="perf_test">
                <caption>Web Performance Test</caption>
                <tbody>
                    <tr>
                        <th>Threshold</th>
                        <th>Duration</th>
                        <th>Transmit</th>
                        <th>Receive</th>
                        <th>Error</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="WebPerformance/@Threshold"/></td>
                        <td><xsl:value-of select="WebPerformance/@Duration"/></td>
                        <td><xsl:value-of select="WebPerformance/@Transmit"/></td>
                        <td><xsl:value-of select="WebPerformance/@Receive"/></td>
                        <td><xsl:value-of select="WebPerformance/@Error"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="perf_test">
                <caption>Video Performance Test</caption>
                <tbody>
                    <tr>
                        <th>Threshold</th>
                        <th>Duration</th>
                        <th>Transmit</th>
                        <th>Receive</th>
                        <th>Error</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="VideoPerformance/@Threshold"/></td>
                        <td><xsl:value-of select="VideoPerformance/@Duration"/></td>
                        <td><xsl:value-of select="VideoPerformance/@Transmit"/></td>
                        <td><xsl:value-of select="VideoPerformance/@Receive"/></td>
                        <td><xsl:value-of select="VideoPerformance/@Error"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="dhcp_test">
                <caption>DHCP Test</caption>
                <tbody>
                    <tr>
                        <th>Type</th>
                        <th>Address</th>
                        <th>Router</th>
                        <th>Server</th>
                        <th>Subnet Mask</th>
                        <th>Domain</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="DHCP/@Type"/></td>
                        <td><xsl:value-of select="DHCP/@Address"/></td>
                        <td><xsl:value-of select="DHCP/@Router"/></td>
                        <td><xsl:value-of select="DHCP/@Server"/></td>
                        <td><xsl:value-of select="DHCP/@Subnet"/></td>
                        <td><xsl:value-of select="DHCP/Domain"/></td>
                    </tr>
                </tbody>
            </table>
            <table class="ping_test">
                <caption>Ping Test</caption>
                <tbody>
                    <tr>
                        <th>Address</th>
                        <th>Interval</th>
                        <th>Size</th>
                        <th>Count</th>
                        <th>Transmitted</th>
                        <th>Received</th>
                        <th>Errors</th>
                        <th>Threshold</th>
                        <th>Target</th>
                    </tr>
                    <tr>
                        <td><xsl:value-of select="Ping/@Address"/></td>
                        <td><xsl:value-of select="Ping/@Interval"/></td>
                        <td><xsl:value-of select="Ping/@Size"/></td>
                        <td><xsl:value-of select="Ping/@Count"/></td>
                        <td><xsl:value-of select="Ping/@Transmitted"/></td>
                        <td><xsl:value-of select="Ping/@Received"/></td>
                        <td><xsl:value-of select="Ping/@Errors"/></td>
                        <td><xsl:value-of select="Ping/@Threshold"/></td>
                        <td><xsl:value-of select="Ping/Target"/></td>
                    </tr>
                </tbody>
            </table>
      </div>
    </xsl:for-each>
    </body>
    </html>
    </xsl:template>
</xsl:stylesheet>
